<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BaseImportExport extends Model 
{

    protected $table = 'import_export_jobs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('client_id', 'plate', 'mercancy', 'chofer', 'parking', 'controlled', 'circuit', 'notes');
    protected $visible = array('client_id', 'plate', 'mercancy', 'chofer', 'parking', 'controlled', 'circuit', 'notes');

    public function client()
    {
        return $this->belongsTo('Client');
    }

}